#迷路脱出（右手法）
import random

# 迷路の幅と高さ。スタートは左上、ゴールは右下です。
mapw, maph = 11, 9
sx, sy = 1, 1
ex, ey = mapw - 2, maph - 2
# 迷路のデータです。
maze_map = [
    ["#","#","#","#","#","#","#","#","#","#","#"],
    ["#"," "," "," ","#"," "," "," "," "," ","#"], 
    ["#","#","#"," ","#"," ","#","#","#"," ","#"], 
    ["#"," "," "," ","#"," "," "," ","#"," ","#"], 
    ["#","#","#"," ","#"," ","#"," ","#","#","#"], 
    ["#"," "," "," "," "," ","#"," ","#"," ","#"], 
    ["#"," ","#"," ","#","#","#"," ","#"," ","#"], 
    ["#"," "," "," ","#"," "," "," "," "," ","#"], 
    ["#","#","#","#","#","#","#","#","#","#","#"]]

def espace_maze(y, x):
    # 調べる方向を用意します（下、右、上、左）。
    dx = [0, 1, 0, -1]
    dy = [1, 0, -1, 0]
    dID = 0
    count = 0
    # ゴールにたどり着くまでくり返し調べていきます。
    while maze_map[y][x] != "G":
        # mapに歩数を２桁の数字で書き込みます。
        maze_map[y][x] =  f"{count:02d}"
        count = count + 1
        # 1つ手前の方向から調べていきます。
        dID = (dID - 1) % 4
        for i in range(4):
            # 進める方向が壁でなければ進めます。
            p = maze_map[y + dy[dID]][x + dx[dID]]
            if p != "#":
                x += dx[dID]
                y += dy[dID]
                break
            # 調べる方向を次に進めます。
            dID = (dID + 1) % 4
    print("脱出", count,"歩")

# 迷路の脱出ルートを見つけます。
maze_map[ey][ex] = "G"
espace_maze(sy, sx)
maze_map[sy][sx] = "S"

# 迷路の脱出ルートを表示します。
for i in maze_map:
    line = ""
    for j in i:
        # 2桁の数字にあわせて、1文字は2文字にします。
        if len(j)==1:
            j = j*2
        line += j + " "
    print(line)
    